/* 
 * Copyright 2000, International Business Machines Corporation and others.
 * All Rights Reserved.
 * 
 * This software has been released under the terms of the IBM Public
 * License.  For details, see the LICENSE file in the top-level source
 * directory or online at http://www.openafs.org/dl/license10.html
 */

/* Copyright (C) 1994 Cazamar Systems, Inc. */

#define IDM_CMD1	101
#define IDM_CMD2	102
#define IDM_CMD3	103
#define IDM_CMD4	104
#define IDM_NLABEL	105	/* never sent */
#define IDM_NAME	106	/* name */
#define IDM_TYPES	107	/* result list */
#define IDM_RESULTS	108	/* result list */
#define IDM_STATUS	109

#define IDM_ABOUT	1000	/* about box */
#define IDM_HELP	1001	/* get help */

#define IDM_FILEBOX	2000	/* for getting file name */
#define IDM_FILENAME	2001	/* for getting file name */

/* this define is generated by manually to correspond to dbrpc_ClientIfHandle.
 * It turns out that the MS linker adds an extra level of indirection to exported
 * globals.  Rather than use confusing names, we rename the thing to have an extra
 * p suffix, but since no one's defining the type of this symbol, we do it manually
 * here.
 */
extern RPC_IF_HANDLE *dbrpc_v1_0_c_ifspecp;

BOOL InitApplication(HANDLE);
BOOL InitInstance(HANDLE, INT);
LONG APIENTRY MainWndProc(HWND, UINT, UINT, LONG);
BOOL APIENTRY About(HWND, UINT, UINT, LONG);
BOOL APIENTRY FileProc(HWND, UINT, UINT, LONG);

typedef struct main_formatCache {
	struct main_formatCache *nextp;
	char *typep;
	long region;
	long index;
	char *labelp;	/* null means we know this doesn't exist */
	long format;
} main_formatCache_t;

extern void main_SetStatus(char *);

/* max of 10 lines on the screen */
#define HW_NLINES 10

/* screen image to write to from tests
 * This shouldn't be global, but it doesn't matter that much.
 */
extern char main_screenText[HW_NLINES][80];

#ifdef WIN32
#define GET_WM_HSCROLL_CODE(wp, lp)    LOWORD(wp)
#define GET_WM_HSCROLL_POS(wp, lp)     HIWORD(wp)
#define GET_WM_HSCROLL_HWND(wp, lp)    (HWND)(lp)
#else
#define GET_WM_HSCROLL_CODE(wp, lp)    (wp)
#define GET_WM_HSCROLL_POS(wp, lp)     LOWORD(lp)
#define GET_WM_HSCROLL_HWND(wp, lp)    (HWND)HIWORD(lp)
#endif
